--Sets up file for use with cal3d mass exporter

thePath = getSavePath() --get path dialog for a set of max files

if thePath != undefined do --if the user did not cancel
(
	theFiles = getFiles (thePath+"\\*.max") --collect all max files in the dir.
	disableSceneRedraw()
	
	fileCountdown = undefined
	for f in theFiles do --go through all of them
	(
		
		------------------------- File Countdown ---------------------------
		if fileCountdown == undefined do fileCountdown = theFiles.count -- Set the countdown to the number of files to go through
		print ((fileCountdown as string) + " files left until finished.")
		print ("Current file is: " + (f as string))
		fileCountdown -= 1 -- Increment it down
		----------------------- End File Countdown ------------------------
		
		loadMaxFile f quiet:true --load the next file
		
		--------------------------- Set up selection sets ----------------------------
		-- Set up skinned geometry selection set
		-- Note: Currently only reliable for CC2 set of files. Later should check for a skin or physique modifier
		SelectionSets["meshes"] = for o in geometry where (classof o == PolyMeshObject) collect o
		
		-- Set up root bone selection set
		SelectionSets["root"] = for o in geometry where (classof o == Biped_Object and o.name == "Bip01") collect o
		
		-- Set up bone selection set
		SelectionSets["bones"] = for o in geometry where (classof o == Biped_Object) collect o
		
		------------------------ End set up selection sets ---------------------------
		
		saveMaxFile f --save the file back to disk
		gc() -- garbage control
	)--end f loop
	
	resetMaxFile #noPrompt --at the end, you can reset 
	enableSceneRedraw()
)--end if
